/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class ItemStackSerializer
implements JsonDeserializer<class_1799> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            return ItemStackSerializer.getItemStack(jsonObject);
        }
        throw new JsonSyntaxException("Expected " + String.valueOf(json) + " to be a ItemStack because it's not an object");
    }

    private static class_1792 getItem(String itemName) {
        class_2960 itemKey = new class_2960(itemName);
        if (!class_7923.field_41178.method_10250(itemKey)) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemKey);
        return Objects.requireNonNull(item);
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            return element.isJsonObject() ? class_2522.method_10718((String)GSON.toJson(element)) : class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException var2) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf((Object)var2));
        }
    }

    private static class_1799 getItemStack(JsonObject json) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = ItemStackSerializer.getItem(itemName);
        if (json.has("nbt")) {
            class_2487 nbt = ItemStackSerializer.getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }
}

